<?php include("inc/header.php"); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TIM 25 Physics Conference</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: auto;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #003366;
            text-align: center;
        }
        h2 {
            color: #0055A4;
            border-bottom: 2px solid #0055A4;
            padding-bottom: 5px;
        }
        p {
            line-height: 1.6;
            font-size: 110%;
            text-align: justify;
        }
        a {
            color: #d35400;
            text-decoration: none;
            font-weight: bold;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Welcome to TIM 25 Physics Conference</h1>
        <p>
            The Conference is organized by the <strong>West University of Timisoara, Faculty of Physics</strong>. 
            The scientific program will include invited lectures, oral and poster presentations, and discussions on topics such as 
            condensed matter physics, theoretical physics, and more.
        </p>

        <h2>Conference Venue</h2>
        <p>
            The conference will take place at the <strong>Faculty of Physics, West University of Timisoara</strong>. 
            More details about the venue can be found <a href="https://www.physics.uvt.ro/" target="_blank">here</a>.
        </p>

        <h2>About Timisoara</h2>
        <p>
            Timisoara, known as the "Little Vienna," is a vibrant city rich in history and culture. 
            It offers stunning architecture, beautiful parks, and a lively atmosphere. 
            Explore more about the city <a href="https://romaniatourism.com/timisoara.html" target="_blank">here</a>.
        </p>
    </div>
</body>
</html>

<?php include("inc/footer.php"); ?>

